#include "GetPointOsnappedOnCurve.js"

function DoCircleTangent()
{
	var ui = moi.ui;
	var circlefactory = moi.command.createFactory( 'circletangent' );
	var pointpicker = ui.createPointPicker();
	pointpicker.disableStraightSnap = true;
	pointpicker.enableOnObjectSnap = true;

	if ( !GetPointOsnappedOnCurve( pointpicker ) )
		return;

	circlefactory.setInput( 1, pointpicker.pt );

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	ui.showUI( 'SecondPrompt' );
	ui.endUIUpdate();

	if ( !GetPointOsnappedOnCurve( pointpicker ) )
		return;

	circlefactory.setInput( 2, pointpicker.pt );
	
	var frame = circlefactory.frame;
	if ( frame == null )
		return;
	pointpicker.restrictToPlane( frame, true );		
	pointpicker.disableBasePt = true;

	ui.beginUIUpdate();
	ui.hideUI( 'SecondPrompt' );
	ui.showUI( 'ThirdPrompt' );
	ui.showUI( 'RadiusOptions' );
	ui.endUIUpdate();

	pointpicker.bindResultPt( circlefactory.getInput(3) );
	
	ui.commandUI.g_Factory = circlefactory;
	pointpicker.bindFuncPostUpdate( ui.commandUI.OnUpdate );

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'distanceinput' || pointpicker.event == 'circumference' )
		{
		    circlefactory.setInput( 0, ui.commandUI.g_UseRadius );

		    if ( pointpicker.event == 'distanceinput' )
		    {
		        circlefactory.setInput( 4, ui.commandUI.distanceinput.value );
		    }
		    else
		    {
		        var circ = ui.commandUI.circumference.value;
		        circlefactory.setInput( 4, ui.commandUI.g_UseRadius ? circ / (2.0 * Math.PI) : circ / Math.PI );
		    }

			circlefactory.update();
			break;
		}
		else if ( pointpicker.event == 'finished' )
		{
			break;
		}
	}
		
	circlefactory.commit();
}	

DoCircleTangent();
